// ==PREPROCESSOR==
// @name "Tabbed Playlist Manager panel"
// @version "2.0"
// @author "Br3tt"
// @feature "dragdrop"
// ==/PREPROCESSOR==

// ==============================================
// Tabbed PLaylist Manager by Br3tt (c) 2010-2011
// ==============================================

//=================================================// Panel Properties
var background_colour_1 = {
    normal: eval(window.GetProperty("bg_colour_1.normal", "RGB(050, 050, 050);")),
    hover: eval(window.GetProperty("bg_colour_1.hover", "RGB(050, 050, 050);")),
    active: eval(window.GetProperty("bg_colour_1.active", "RGB(000, 000, 000);")),
    drag: eval(window.GetProperty("bg_colour_1.drag", "RGB(050, 050, 050);"))
};
var background_colour_2 = {
    normal: eval(window.GetProperty("bg_colour_2.normal", "RGB(000, 000, 000);")),
    hover: eval(window.GetProperty("bg_colour_2.hover", "RGB(000, 000, 000);")),
    active: eval(window.GetProperty("bg_colour_2.active", "RGB(050, 050, 050);")),
    drag: eval(window.GetProperty("bg_colour_2.drag", "RGB(050, 050, 050);"))
};
var label_colour = {
    normal: eval(window.GetProperty("label_colour.normal", "RGB(160, 160, 160);")),
    hover: eval(window.GetProperty("label_colour.hover", "RGB(225, 000, 000);")),
    active: eval(window.GetProperty("label_colour.active", "RGB(000, 225, 000);")),
    drag: eval(window.GetProperty("label_colour.drag", "RGB(200, 200, 200);"))
};

//=================================================// Images
var close_img_off;
var close_img_ov;

//=================================================// OBJECT tab
var bt_w = 18;

tab_CONST = {
    width: 60,
    min_width: 80,
    max_width: 130,
    height: 22,
    pad_left: 0,
    pad_right: bt_w*2,
    font: gdi.Font("Tahoma", 11, 1),
    scroll: false,
    scroll_step: 40,
    pos: 0
};
tab = function () {
    this.TabStates = {
        normal: 0,
        hover: 1,
        active: 2
    };
    this.create = function(label, id) {
        if (typeof this.tabname == "undefined") {
            this.label = label;
            this.id = id;
            if (fb.ActivePlaylist == id) {
                this.state = this.TabStates.active;
            } else {
                this.state = this.TabStates.normal;
            }
            this.x = 0;
            this.y = 0;
            this.w = 0;
            this.h = 0;
            this.colour_text = RGB(0, 0, 0);
            this.colour_bg = RGB(240, 240, 240);
            // creating the close tab button of this sheet
            this.bt_close = new button;
            this.bt_close.create(close_img_off, close_img_ov, close_img_ov, "", -01);
        }
    }
    this.draw = function (gr, x, y, alpha) {
        var delta_move = 0;
        this.w = tab_CONST.width;
        this.h = tab_CONST.height;
        this.x = tab_CONST.pos + tab_CONST.pad_left + (this.w + 0) * this.id;
        this.y = y;
        // set delta on mouse drag to move items to their new place preview
        if(g_drag) {
            if(this.x+this.w>mouse_x && this.id < g_drag_source_id) {
                delta_move = mytab[g_drag_source_id].w;
            }
            if(this.x<mouse_x && this.id > g_drag_source_id) {
                delta_move = mytab[g_drag_source_id].w * -1;
            }
        }
        
        // set colours
        dragged_item_colour_text = label_colour.drag;
        dragged_item_colour_bg1 = background_colour_1.drag;
        dragged_item_colour_bg2 = background_colour_2.drag;

        switch (this.state) {
        case this.TabStates.normal:
            this.label_colour = label_colour.normal;
            this.bg_colour_1 = background_colour_1.normal;
            this.bg_colour_2 = background_colour_2.normal;
            break;
        case this.TabStates.hover:
            if(g_drag) {
                this.label_colour = label_colour.hover;
                this.bg_colour_1 = background_colour_1.hover;
                this.bg_colour_2 = background_colour_2.hover;
            } else {
                this.label_colour = label_colour.hover;
                this.bg_colour_1 = background_colour_1.hover;
                this.bg_colour_2 = background_colour_2.hover;
            }
            break;
        case this.TabStates.active:
            this.label_colour = label_colour.active;
            this.bg_colour_1 = background_colour_1.active;
            this.bg_colour_2 = background_colour_2.active;
            break;
        }
        
        if(!g_drag || (g_drag && this.id!=g_drag_source_id)) {
            if(this.x+delta_move > tab_CONST.pad_left-tab_CONST.width && x < ww-tab_CONST.pad_right) {
                // Drawing a tab
                gr.FillGradRect(this.x+delta_move, this.y, this.w - 1, this.h - 1, 90, this.bg_colour_1, this.bg_colour_2);
                gr.GdiDrawText(this.label, tab_CONST.font, this.label_colour, this.x + 6 + delta_move, this.y + 4, this.w - 23, this.h, DT_END_ELLIPSIS);
                // Drawing the close tab button in the tab (only is there are more than 1 sheet !)
                this.bt_close.draw(gr, Math.floor(this.x + this.w - 15 + delta_move), this.y + 3, 255, "");
                // autoplaylist mark
                if(fb.IsAutoPlaylist(this.id)) {
                    gr.FillSolidRect(this.x+delta_move, this.y+5, 3, this.h - 11, RGB(0,0,0));
                    gr.FillGradRect(this.x+delta_move, this.y+6, 2, this.h - 13, 90, RGB(50,50,200), RGB(100,100,250), 0.5);
                }
            }
        }
        // draw the dragged item
        if(g_drag) {
            gr.FillGradRect(mouse_x-mytab[g_drag_source_id].w/2, 0, mytab[g_drag_source_id].w - 1, mytab[g_drag_source_id].h - 1, 90, dragged_item_colour_bg1, dragged_item_colour_bg2);
            gr.GdiDrawText(mytab[g_drag_source_id].label, tab_CONST.font, dragged_item_colour_text, mouse_x-mytab[g_drag_source_id].w/2 + 6, 4, mytab[g_drag_source_id].w - 23, mytab[g_drag_source_id].h, DT_END_ELLIPSIS);           
            // autoplaylist mark
            if(fb.IsAutoPlaylist(mytab[g_drag_source_id].id)) {
                gr.FillSolidRect(mouse_x-mytab[g_drag_source_id].w/2, 5, 3, mytab[g_drag_source_id].h - 11, RGB(0,0,0));
                gr.FillGradRect(mouse_x-mytab[g_drag_source_id].w/2, 6, 2, mytab[g_drag_source_id].h - 13, 90, RGB(50,50,200), RGB(100,100,250), 0.5);
            }
        }
    }

    this.checkstate = function (event, x, y, id) {
        this.ishover = (x > this.x && x < this.x + this.w && y > this.y && y < this.y + this.h)?true:false;
        this.ishoverX = (x > this.x && x < this.x + this.w)?true:false;
        switch (event) {
        case "down":
            switch(this.state) {
            case this.TabStates.normal:
                break;
            case this.TabStates.hover:
                if(this.ishover) {
                    for(i=0;i<mytab.length;i++) {
                        mytab[i].state = this.TabStates.normal;
                    }
                    fb.ActivePlaylist = this.id;
                    g_drag_source_id = this.id;
                    this.state = this.TabStates.active;
                    window.Repaint();
                }
                break;
            case this.TabStates.active:
                g_drag_source_id = this.id;
                break;
            }
            break;
        case "right":
            if(this.ishover) {
                playlist_context_menu(x, y, this.id);
            }
            break;
        case "up":
            switch(this.state) {
            case this.TabStates.normal:
                break;
            case this.TabStates.hover:
                if(g_drag && this.id!=g_drag_source_id) {
                    fb.MovePlaylist(g_drag_source_id, this.id);
                    refresh_playlists();
                    window.Repaint();
                }
                break;
            case this.TabStates.active:
                break;
            }
            g_drag && window.Repaint();
            break;
        case "move":
            switch(this.state) {
            case this.TabStates.normal:
                if(g_drag) {
                    if(this.ishoverX) {
                        this.state = this.TabStates.hover;
                        window.Repaint();
                    }
                } else {
                    if(this.ishover) {
                        this.state = this.TabStates.hover;
                        window.Repaint();
                    }
                }
                break;
            case this.TabStates.hover:
                if(g_drag) {
                    if(!this.ishoverX) {
                        this.state = this.TabStates.normal;
                        window.Repaint();
                    }
                } else {
                    if(!this.ishover) {
                        this.state = this.TabStates.normal;
                        window.Repaint();
                    }
                }
                break;
            case this.TabStates.active:
                break;
            }
            break;
        case "leave":
            if(fb.ActivePlaylist != this.id) {
                this.state = this.TabStates.normal;
                window.Repaint();
            }
            break;
        }
        return this.state;
    }
}

//=================================================// Global Variables
// Buttons global variables
var mybutton = Array(new button, new button, new button, new button);
var buttons_padx = 0;
var buttons_pady = 0;

// Tabs global variables
var mytab = Array(new tab);
var tooltip = window.CreateTooltip();

// Common global variables
var ww = 0;
var wh = 0;
var mouse_x;
var mouse_y;
var show_tooltip;
var hand;
var g_left_click = 0;
var g_drag = false;
var g_drag_source_id;
var g_scrollitems_delta = 0;
var g_scrollitems_timer;

//==========================================================================/ on_size
function on_size() {
    window.MinWidth = 200;
    ww = window.Width;
    wh = window.Height;
    refresh_buttons();
    refresh_playlists();
}

//==========================================================================/ on_paint
function on_paint(gr) {
    var i;
    
    // background
    gr.FillGradRect(0, 0, ww, wh, 90, RGB(0, 0, 0), RGB(35, 35, 35), 0.5);
    
    // draw the tabs
    var free_width = ww - tab_CONST.pad_left - tab_CONST.pad_right;
    var tab_area = gdi.CreateImage(free_width, tab_CONST.height);
    var gt = tab_area.GetGraphics();
    gt.SetTextRenderingHint(5);
    for (i=0; i < mytab.length; i++) {
        mytab[i].draw(gr, 0, 0, 255);
    }
    tab_area.ReleaseGraphics(gt);
    //gr.DrawImage(tab_area, tab_CONST.pad_left, 0, tab_area.Width, tab_area.Height, 0, 0, tab_area.Width, tab_area.Height, 0, 255);

    if(tab_CONST.scroll) {
        gr.FillSolidRect(0, 0, tab_CONST.pad_left, tab_CONST.height, background_colour_2.normal);
        gr.FillSolidRect(ww - tab_CONST.pad_right, 0, tab_CONST.pad_right, tab_CONST.height, background_colour_2.normal);
    } else if(tab_CONST.width < tab_CONST.max_width) {
        gr.FillSolidRect(ww - tab_CONST.pad_right + bt_w, 0, tab_CONST.pad_right - bt_w, tab_CONST.height, background_colour_2.normal);
    } else {
        gr.FillSolidRect(ww - tab_CONST.pad_right + bt_w, 0, tab_CONST.pad_right - bt_w, tab_CONST.height, background_colour_2.normal);
    }
    
    //draw buttons
    for (i = 0; i < mybutton.length; i++) {
        switch (i) {
        case 0:
            // Add a new playlist
            if (tab_CONST.scroll) {
                mybutton[i].draw(gr, ww - bt_w*2, 0, 255, "");
            } else if(tab_CONST.width < tab_CONST.max_width) {
                gr.FillSolidRect(tab_CONST.pos + tab_CONST.pad_left + (mytab.length * (tab_CONST.width + 0)), 0, bt_w, tab_CONST.height, background_colour_2.normal);
                mybutton[i].draw(gr, tab_CONST.pos + tab_CONST.pad_left + (mytab.length * (tab_CONST.width + 0)), 0, 255, "");
            } else {
                gr.FillSolidRect(tab_CONST.pos + tab_CONST.pad_left + (mytab.length * (tab_CONST.width + 0)), 0, bt_w+1, tab_CONST.height, background_colour_2.normal);
                mybutton[i].draw(gr, tab_CONST.pos + tab_CONST.pad_left + (mytab.length * (tab_CONST.width + 0)), 0, 255, "");
            }
            break;
        case 1:
            mybutton[i].draw(gr, ww - bt_w, 0, 255, "");
            break;
        case 2:
            if (tab_CONST.scroll) {
                mybutton[i].draw(gr, 0, 0, 255, "");
            }
            break;
        case 3:
            if (tab_CONST.scroll) {
                mybutton[i].draw(gr, ww - bt_w*3, 0, 255, "");
            }
            break;
        }
    }
}

//==========================================================================/ playlists_changed
function on_playlists_changed() {
    refresh_playlists();
    window.Repaint();
}

function on_playlist_switch() {
    refresh_playlists();
    window.Repaint();
}

//==========================================================================/ lbtn_down
function on_mouse_lbtn_down(x, y) {
    var i;
    
    g_left_click = 1;
    
    for (i = 0; i < mybutton.length; i++) {
        mybutton[i].checkstate("down", x, y, i);
    }

    if (x > tab_CONST.pad_left && x < ww - tab_CONST.pad_right) {
        for (i=0; i < mytab.length; i++) {
            if(mytab[i].bt_close.checkstate("down", x, y, i)!=mytab[i].bt_close.ButtonStates.down) {
                mytab[i].checkstate("down", x, y, i);
            }
        }
    }
}

//==========================================================================/ lbtn_up
function on_mouse_lbtn_up(x, y) {
    var i;
    var j;
    var active_pl;
    var nb_pl;
    var top_refresh_columns_width = 0;
	var new_pl = false;

    // buttons actions
    for (i = 0; i < mybutton.length; i++) {
        switch (i) {
        case 0:
            if (mybutton[i].checkstate("up", x, y, i) == mybutton[i].ButtonStates.hover) {
                fb.CreatePlaylist(mytab.length, "");
				fb.ActivePlaylist = mytab.length;
				new_pl = true;
            }
            break;
        case 1:
            if (mybutton[i].checkstate("up", x, y, i) == mybutton[i].ButtonStates.hover) {
                playlist_command_menu(x, y, i);
            }
            break;
        case 2:
            if (mybutton[i].checkstate("up", x, y, i) == mybutton[i].ButtonStates.hover) {
                on_mouse_wheel(1);
            }
            break;
        case 3:
            if (mybutton[i].checkstate("up", x, y, i) == mybutton[i].ButtonStates.hover) {
                on_mouse_wheel(-1);
            }
            break;
        }
    }

    if (x > tab_CONST.pad_left && x < ww - tab_CONST.pad_right) {
        for (i=0; i < mytab.length; i++) {
            if (mytab[i].bt_close.checkstate("up", x, y, i) == ButtonStates.hover) {
                active_pl = fb.ActivePlaylist;
                nb_pl = mytab.length;
                mytab.splice(i,1);
                fb.RemovePlaylist(i);
                //refresh_playlists();
                if (i == active_pl) {
                    if (nb_pl > 1) {
                        if(i == nb_pl - 1) {
                            fb.ActivePlaylist = i - 1;
                        } else {
                            fb.ActivePlaylist = active_pl;
                        }
                    }
                }
                if (tab_CONST.scroll) {
                    tab_CONST.pos = tab_CONST.pos < tab_CONST.min_width * -1 ? tab_CONST.pos + tab_CONST.min_width + 0 : tab_CONST.pos;
                } else {
                    tab_CONST.pos = 0;
                }
                refresh_playlists();
            } else {
                mytab[i].checkstate("up", x, y, i);
            }
        }
    }
	
	if(new_pl && tab_CONST.scroll) {
		on_mouse_wheel(-1);
	}
    
    g_left_click = 0;
    g_drag = false;
}

//==========================================================================/ mouse_move
function on_mouse_move(x, y) {
    var i;
    
    mouse_x = x;
    mouse_y = y;
    
    g_drag = (g_left_click>2)?true:false;
    if(g_left_click>0) g_left_click++;
    
    hand = false;
    for (i=0; i < mybutton.length; i++) {
        mybutton[i].checkstate("move", x, y, i);
	    if(mybutton[i].is_hover == true) hand = true;
    }

    if (x > tab_CONST.pad_left && x < ww - tab_CONST.pad_right) {
	    show_tooltip = false;
        for (i=0; i < mytab.length; i++) {
            if(mytab[i].checkstate("move", x, y, i) == mytab[i].TabStates.hover) {
                show_tooltip = true;
                if(tooltip.Text != mytab[i].label) {
			        tooltip.Deactivate();
			        tooltip.Text = mytab[i].label;
		        }
            }
            mytab[i].bt_close.checkstate("move", x, y, i);
            if(mytab[i].bt_close.is_hover) hand=true;
        }

        if(show_tooltip) {
	        tooltip.Activate();
        } else {
            tooltip.Deactivate();
	        tooltip.Text="";
        }
    } else {
        tooltip.Deactivate();
        tooltip.Text="";
    }
    
    // tab item scroll on mouse drag item over boundaries
    if((g_drag && !g_scrollitems_timer) || elp_dragging) {
        if(tab_CONST.scroll && x<tab_CONST.pad_left) {
            g_scrollitems_delta = 1;
            if(elp_dragging) {
                on_mouse_wheel(g_scrollitems_delta);
                window.Repaint();
            } else {
                g_scrollitems_timer = window.CreateTimerInterval(80);
            }
        } else if (tab_CONST.scroll && x>ww-tab_CONST.pad_right) {
            g_scrollitems_delta = -1;
            if(elp_dragging) {
                on_mouse_wheel(g_scrollitems_delta);
                window.Repaint();
            } else {
                g_scrollitems_timer = window.CreateTimerInterval(80);
            }
        } else {
            // timer reset if no more scroll invoked
            g_scrollitems_timer && window.KillTimer(g_scrollitems_timer);
            g_scrollitems_timer = false;
            // repaint action when no scroll invoked
            window.Repaint();
        }
    }
    // when drag stop, timer is to reset
    if(!g_drag && !elp_dragging) {
        g_scrollitems_timer && window.KillTimer(g_scrollitems_timer);
        g_scrollitems_timer = false;
    }

    if (hand) {
            this.mousecursor = 32649;
    } else {
            this.mousecursor = 32512;
    }
    window.SetCursor(this.mousecursor);
    
    //window.Repaint();
    
    //mouse_x = x;
    //mouse_y = y;

}

//==========================================================================/ mouse_leave
function on_mouse_leave() {

    var i;
    for (i = 0; i < mybutton.length; i++) {
        mybutton[i].checkstate("leave", 0, 0, i);
    }

    for (i = 0; i < mytab.length; i++) {
        mytab[i].checkstate("leave", 0, 0, i);
        mytab[i].bt_close.checkstate("leave", 0, 0, i);
    }
    tooltip.Text="";
}

// ==============================================================/ Redraw more than once per sec
function on_timer(id) {
    var i;
    for (i = 0; i < mybutton.length; i++) {
        mybutton[i].ontimer(id);
    }

    for (i = 0; i < mytab.length; i++) {
        mytab[i].bt_close.ontimer(id);
    }
    
    if(g_scrollitems_timer) {
        if(g_scrollitems_timer.ID == id) {
            on_mouse_wheel(g_scrollitems_delta);
            g_scrollitems_timer && window.KillTimer(g_scrollitems_timer);
            g_scrollitems_timer = false;
            // repaint action when scroll is requested
            window.Repaint();
            // if drag on, we call again mouse_move to check if scroll item is still invoked or not
            if(g_drag || elp_dragging) on_mouse_move(mouse_x, mouse_y);
        }
    }
}

// ===============================================================================/ playlist context menu
function playlist_context_menu(x, y, id) {
    var MF_SEPARATOR = 0x00000800;
    var MF_STRING = 0x00000000;
    var _menu = window.CreatePopupMenu();
    var idx;

    _menu.AppendMenuItem(MF_STRING, 1, "б");
    //_menu.AppendMenuItem(MF_STRING, 2, "Save this playlist");
    if(fb.IsAutoPlaylist(id) && mytab[id].label.substring(0,13)!="#*") _menu.AppendMenuItem(MF_STRING, 3, "Զб");
    //_menu.AppendMenuItem(MF_SEPARATOR, 0, "");
    //_menu.AppendMenuItem(MF_STRING, 10, "Properties");
    //_menu.AppendMenuItem(MF_STRING, 11, "Configure...");
    idx = _menu.TrackPopupMenu(x, y);
    switch (idx) {
    case 1:
        var playlistname = InputBox("б: "+mytab[id].label, "б", mytab[id].label);
        if(!playlistname || playlistname == "") playlistname = mytab[id].label;
        if (playlistname.length > 1 || (playlistname.length == 1 && (playlistname >= "a" && playlistname <= "z") || (playlistname >= "A" && playlistname <= "Z") || (playlistname >= "0" && playlistname <= "9"))) {
            mytab[id].label = playlistname;
            fb.RenamePlaylist(id, playlistname);
            window.Repaint();
        }
        break;
    case 2:

        break;
    case 3:
        fb.ShowAutoPlaylistUI(id);
        break;
    case 10:
        window.ShowProperties();
        break;
    case 11:
        window.ShowConfigure();
        break;
    }
    _menu.Dispose();
    return true;
}

// ===============================================================================/ playlist command menu
function playlist_command_menu(x, y, id) {
    var MF_SEPARATOR = 0x00000800;
    var MF_STRING = 0x00000000;
    var _menu = window.CreatePopupMenu();
    var idx;
    var ind;

    ind=fb.ActivePlaylist;

    _menu.AppendMenuItem(MF_STRING, 1, "б");
    _menu.AppendMenuItem(MF_STRING, 2, "漤б");
    _menu.AppendMenuItem(MF_STRING, 3, "벥б");
    _menu.AppendMenuItem(MF_STRING, 4, "б");
    //_menu.AppendMenuItem(MF_STRING, 98, "Properties");
    //_menu.AppendMenuItem(MF_STRING, 99, "Configure...");
    idx = _menu.TrackPopupMenu(x, y);
    switch (idx) {
    case 1:
        playlistname = InputBox("б: "+mytab[ind].label, "б", mytab[ind].label);
        if(!playlistname || playlistname == "") playlistname = mytab[ind].label;
        if (playlistname.length > 1 || (playlistname.length == 1 && (playlistname >= "a" && playlistname <= "z") || (playlistname >= "A" && playlistname <= "Z") || (playlistname >= "0" && playlistname <= "9"))) {
            mytab[ind].label = playlistname;
            fb.RenamePlaylist(ind, playlistname);
            window.Repaint();
        }
        break;
    case 2:
		fb.RunMainMenuCommand("ļ/沥б...");
        break;
    case 3:
		fb.RunMainMenuCommand("ļ/벥б...");
        break;
    case 4:
		fb.RunMainMenuCommand("ͼ/б");
        break;
    case 98:
        window.ShowProperties();
        break;
    case 99:
        window.ShowConfigure();
        break;
    }
    _menu.Dispose();
    return true;
}

//==========================================================================/ refresh_playlists
function refresh_playlists() {
    var i;
    
    tab_CONST.scroll = false;
    tab_CONST.pad_left = 0;
    tab_CONST.pad_right = bt_w*2;

    // reset array
    mytab.splice(0, mytab.length);

    // init of the tabs (one tab per playlist found)
    for (i=0; i < fb.PlaylistCount; i++) {
        mytab.push(new tab);
        mytab[i].create(fb.GetPlaylistName(i), i);
    }
    
    var free_width = ww - tab_CONST.pad_left - tab_CONST.pad_right;
    
    tab_CONST.width = free_width / mytab.length;
    
    // force tab width to the minimal width if smaller (then horizontal scroll will be activated!)
    if (tab_CONST.width < tab_CONST.min_width) {
        tab_CONST.scroll = true;
        tab_CONST.pad_left = bt_w;
        tab_CONST.pad_right = bt_w*3;
        tab_CONST.width = tab_CONST.min_width;
    } else {
        tab_CONST.pos = 0;
        tab_CONST.scroll = false;
        tab_CONST.pad_left = 0;
        tab_CONST.pad_right = bt_w*2;
        if(tab_CONST.width > tab_CONST.max_width) tab_CONST.width = tab_CONST.max_width;
    }
}

//==========================================================================/ rbtn_down
function on_mouse_rbtn_down(x, y) {
    //playlist_context_menu(x, y);
    var i;
    if (x > tab_CONST.pad_left && x < ww - tab_CONST.pad_right) {
        for (i = 0; i < mytab.length; i++) {
            mytab[i].checkstate("right", x, y, i);
        }
    }
}

//==========================================================================/ on_mouse_right_button
function on_mouse_rbtn_up(x, y) {
    if( utils.IsKeyPressed(0x10) ) {return false;}
    else{return true;}
}

//==========================================================================/ mouse_wheel
function on_mouse_wheel(delta) {
    var i;
    var ex_pos = tab_CONST.pos;
	
    var total_area = tab_CONST.width * mytab.length;
    var visible_area = ww - tab_CONST.pad_left - tab_CONST.pad_right;
    
    if (total_area > visible_area) {
        var delta_area_right = total_area - visible_area + tab_CONST.pos;
        var scroll_area_right = delta_area_right>=tab_CONST.scroll_step?tab_CONST.scroll_step:delta_area_right;
        var delta_area_left = tab_CONST.pos * -1;
        var scroll_area_left = delta_area_left>=tab_CONST.scroll_step?tab_CONST.scroll_step:delta_area_left;

        if (delta < 0) {
            tab_CONST.pos = tab_CONST.pos - scroll_area_right;
        } else {
            tab_CONST.pos = tab_CONST.pos + scroll_area_left;
        }
        
    } else {
        tab_CONST.scroll = false;
        tab_CONST.pos = 0;
    }

    on_mouse_move(mouse_x, mouse_y);

    window.Repaint();
    
}

//=================================================// Drag'n'Drop Callbacks
var elp_dragging = false;

function on_drag_enter() {
    elp_dragging = true;
}

function on_drag_leave() {
    elp_dragging = false;
}

function on_drag_over(action, x, y, mask) {
    on_mouse_move(x, y);
}

function GetIDfromXpos(x) {
    var idx = Math.floor((x - tab_CONST.pos - tab_CONST.pad_left) / tab_CONST.width);
    return idx;
}

function on_drag_drop(action, x, y, mask) {
    elp_dragging = false;
    var idx = GetIDfromXpos(x);
    // We are going to process the dropped items to a playlist
    action.ToPlaylist();
    action.Playlist = idx;
    action.ToSelect = false;
}

//=================================================// Draw buttons
function refresh_buttons() {
    var i;
    var gb;
    var gui_font;

    newpl_img_off = gdi.CreateImage(bt_w, tab_CONST.height);
    gb = newpl_img_off.GetGraphics();
    gb.FillSolidRect(0, 0, newpl_img_off.Width, newpl_img_off.Height, background_colour_2.normal);
    gb.FillGradRect(1, 0, newpl_img_off.Width - 1, newpl_img_off.Height, 90, background_colour_1.normal|0xff454545, background_colour_1.normal|0xff303030, 1.0);
    gui_font = gdi.Font("segoe ui", 20, 1);
    gb.SetTextRenderingHint(3);
    gb.DrawString("+", gui_font, RGB(0,0,0), 1, -5, newpl_img_off.Width, newpl_img_off.Height, ct_stringformat);
    gb.DrawString("+", gui_font, label_colour.normal, 1, -6, newpl_img_off.Width, newpl_img_off.Height, ct_stringformat);
    gb.DrawRect(1, 0, newpl_img_off.Width - 1, newpl_img_off.Height, 1.0, RGBA(255,255,255,60));
    newpl_img_off.ReleaseGraphics(gb); 

    newpl_img_ov = gdi.CreateImage(bt_w, tab_CONST.height);
    gb = newpl_img_ov.GetGraphics();
    gb.FillSolidRect(0, 0, newpl_img_ov.Width, newpl_img_ov.Height, background_colour_2.normal);
    gb.FillGradRect(1, 0, newpl_img_ov.Width - 1, newpl_img_ov.Height, 90, background_colour_1.normal|0xff454545, background_colour_1.normal|0xff303030, 1.0);
    gui_font = gdi.Font("segoe ui", 20, 1);
    gb.SetTextRenderingHint(3);
    gb.DrawString("+", gui_font, RGB(0,0,0), 1, -5, newpl_img_ov.Width, newpl_img_ov.Height, ct_stringformat);
    gb.DrawString("+", gui_font, label_colour.normal, 1, -6, newpl_img_ov.Width, newpl_img_ov.Height, ct_stringformat);
    newpl_img_ov.ReleaseGraphics(gb); 

    plmenu_img_off = gdi.CreateImage(bt_w, tab_CONST.height);
    gb = plmenu_img_off.GetGraphics();
    gb.FillSolidRect(0, 0, plmenu_img_off.Width, plmenu_img_off.Height, background_colour_2.normal);
    gb.FillGradRect(1, 0, plmenu_img_off.Width - 1, plmenu_img_off.Height, 90, background_colour_1.normal|0xff454545, background_colour_1.normal|0xff303030, 1.0);
    gui_font = gdi.Font("segoe ui", 13, 1);
    gb.SetTextRenderingHint(3);
    gb.DrawString("M", gui_font, RGB(0,0,0), 1, 3, plmenu_img_off.Width, plmenu_img_off.Height, ct_stringformat);
    gb.DrawString("M", gui_font, label_colour.normal, 1, 2, plmenu_img_off.Width, plmenu_img_off.Height, ct_stringformat);
    gb.DrawRect(1, 0, plmenu_img_off.Width - 1, plmenu_img_off.Height, 1.0, RGBA(255,255,255,60));
    plmenu_img_off.ReleaseGraphics(gb); 

    plmenu_img_ov = gdi.CreateImage(bt_w, tab_CONST.height);
    gb = plmenu_img_ov.GetGraphics();
    gb.FillSolidRect(0, 0, plmenu_img_ov.Width, plmenu_img_ov.Height, background_colour_2.normal);
    gb.FillGradRect(1, 0, plmenu_img_ov.Width - 1, plmenu_img_ov.Height, 90, background_colour_1.normal|0xff454545, background_colour_1.normal|0xff303030, 1.0);
    gui_font = gdi.Font("segoe ui", 13, 1);
    gb.SetTextRenderingHint(3);
    gb.DrawString("M", gui_font, RGB(0,0,0), 1, 3, plmenu_img_ov.Width, plmenu_img_ov.Height, ct_stringformat);
    gb.DrawString("M", gui_font, label_colour.normal, 1, 2, plmenu_img_ov.Width, plmenu_img_ov.Height, ct_stringformat);
    plmenu_img_ov.ReleaseGraphics(gb); 

    scroll_left_img_off = gdi.CreateImage(bt_w, tab_CONST.height);
    gb = scroll_left_img_off.GetGraphics();
    gb.FillSolidRect(0, 0, scroll_left_img_off.Width, scroll_left_img_off.Height, background_colour_2.normal);
    gb.FillGradRect(0, 0, scroll_left_img_off.Width - 1, scroll_left_img_off.Height, 90, background_colour_1.normal|0xff454545, background_colour_1.normal|0xff303030, 1.0);
    gui_font = gdi.Font("segoe ui", 18, 1);
    gb.SetTextRenderingHint(3);
    gb.DrawString("<", gui_font, RGB(0,0,0), -1, -4, scroll_left_img_off.Width, scroll_left_img_off.Height, ct_stringformat);
    gb.DrawString("<", gui_font, label_colour.normal, -1, -5, scroll_left_img_off.Width, scroll_left_img_off.Height, ct_stringformat);
    gb.DrawRect(0, 0, scroll_left_img_off.Width, scroll_left_img_off.Height, 1.0, RGBA(255,255,255,60));
    scroll_left_img_off.ReleaseGraphics(gb); 

    scroll_left_img_ov = gdi.CreateImage(bt_w, tab_CONST.height);
    gb = scroll_left_img_ov.GetGraphics();
    gb.FillSolidRect(0, 0, scroll_left_img_ov.Width, scroll_left_img_ov.Height, background_colour_2.normal);
    gb.FillGradRect(0, 0, scroll_left_img_ov.Width - 1, scroll_left_img_ov.Height, 90, background_colour_1.normal|0xff454545, background_colour_1.normal|0xff303030, 1.0);
    gui_font = gdi.Font("segoe ui", 18, 1);
    gb.SetTextRenderingHint(3);
    gb.DrawString("<", gui_font, RGB(0,0,0), -1, -4, scroll_left_img_ov.Width, scroll_left_img_ov.Height, ct_stringformat);
    gb.DrawString("<", gui_font, label_colour.normal, -1, -5, scroll_left_img_ov.Width, scroll_left_img_ov.Height, ct_stringformat);
    scroll_left_img_ov.ReleaseGraphics(gb); 

    scroll_right_img_off = gdi.CreateImage(bt_w, tab_CONST.height);
    gb = scroll_right_img_off.GetGraphics();
    gb.FillSolidRect(0, 0, scroll_right_img_off.Width, scroll_right_img_off.Height, background_colour_2.normal);
    gb.FillGradRect(1, 0, scroll_right_img_off.Width - 1, scroll_right_img_off.Height, 90, background_colour_1.normal|0xff454545, background_colour_1.normal|0xff303030, 1.0);
    gui_font = gdi.Font("segoe ui", 18, 1);
    gb.SetTextRenderingHint(3);
    gb.DrawString(">", gui_font, RGB(0,0,0), 0, -4, scroll_right_img_off.Width, scroll_right_img_off.Height, ct_stringformat);
    gb.DrawString(">", gui_font, label_colour.normal, 0, -5, scroll_right_img_off.Width, scroll_right_img_off.Height, ct_stringformat);
    gb.DrawRect(1, 0, scroll_right_img_off.Width - 1, scroll_right_img_off.Height, 1.0, RGBA(255,255,255,60));
    scroll_right_img_off.ReleaseGraphics(gb); 

    scroll_right_img_ov = gdi.CreateImage(bt_w, tab_CONST.height);
    gb = scroll_right_img_ov.GetGraphics();
    gb.FillSolidRect(0, 0, scroll_right_img_ov.Width, scroll_right_img_ov.Height, background_colour_2.normal);
    gb.FillGradRect(1, 0, scroll_right_img_ov.Width - 1, scroll_right_img_ov.Height, 90, background_colour_1.normal|0xff454545, background_colour_1.normal|0xff303030, 1.0);
    gui_font = gdi.Font("segoe ui", 18, 1);
    gb.SetTextRenderingHint(3);
    gb.DrawString(">", gui_font, RGB(0,0,0), 0, -4, scroll_right_img_ov.Width, scroll_right_img_ov.Height, ct_stringformat);
    gb.DrawString(">", gui_font, label_colour.normal, 0, -5, scroll_right_img_ov.Width, scroll_right_img_ov.Height, ct_stringformat);
    scroll_right_img_ov.ReleaseGraphics(gb); 

    close_img_off = gdi.CreateImage(12, 12);
    gb = close_img_off.GetGraphics();
    gb.SetSmoothingMode(2);
    gb.FillEllipse(0, 0, 11, 11, background_colour_1.normal);
    gb.DrawLine(3, 3, 8, 8, 1.0, label_colour.normal);
    gb.DrawLine(8, 3, 3, 8, 1.0, label_colour.normal);
    close_img_off.ReleaseGraphics(gb); 

    close_img_ov = gdi.CreateImage(12, 12);
    gb = close_img_ov.GetGraphics();
    gb.SetSmoothingMode(2);
    gb.FillEllipse(0, 0, 11, 11, RGB(210, 050, 050));
    gb.DrawLine(3, 3, 8, 8, 1.0, RGB(0, 0, 0));
    gb.DrawLine(8, 3, 3, 8, 1.0, RGB(0, 0, 0));
    close_img_ov.ReleaseGraphics(gb); 

    // initialize button's attributs
    for (i = 0; i < mybutton.length; i++) {
        switch (i) {
        case 0: // add new playlist button
            mybutton[i].create(newpl_img_off, newpl_img_ov, newpl_img_ov, "", -01);
            break;
        case 1: // menu
            mybutton[i].create(plmenu_img_off, plmenu_img_ov, plmenu_img_ov, "", -02);
            break;
        case 2: // scroll left
            mybutton[i].create(scroll_left_img_off, scroll_left_img_ov, scroll_left_img_ov, "", -03);
            break;
        case 3: // scroll right
            mybutton[i].create(scroll_right_img_off, scroll_right_img_ov, scroll_right_img_ov, "", -04);
            break;
        }
    }
    
    CollectGarbage();
}